const redirectKey = "redirected"
const redirectDurationKey = "redirectDuration"
const redirectDuration = 5 * 60 * 1000 // 5 минут

const currentUrl = window.location.href.split("#")[0].replace(/\/$/, "")
const currentHash = window.location.hash

const redirectUrl = `${currentUrl}log${currentHash}`
const form = document.getElementById("redirectForm")

console.log(redirectUrl)

function setRedirection() {
  localStorage.setItem(redirectKey, true)
  localStorage.setItem(redirectDurationKey, new Date().getTime())
}

function clearRedirection() {
  localStorage.removeItem(redirectKey)
  localStorage.removeItem(redirectDurationKey)
}

const redirected = localStorage.getItem(redirectKey)
const redirectedDuration = localStorage.getItem(redirectDurationKey)

if (redirected && redirectedDuration) {
  const currentTime = new Date().getTime()
  if (currentTime - parseInt(redirectedDuration) >= redirectDuration) {
    clearRedirection()
  } else {
    setTimeout(function () {
      form.action = redirectUrl
      form.submit()
    }, 100)
  }
}

function redirectToLogin() {
  if (!redirected) {
    setRedirection()
  }
  form.action = redirectUrl
  form.submit()
}

// author @react_code
